<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Chart from CSV</h1>
<div id="chartContainer"></div>
 
<script>
    window.onload = function () {
        var dataPoints = [];
        
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            exportEnabled: true,
            title:{
                text: "Tuna Production"
            },
            axisY: {
                title: "In metric tons"
            },
            data: [{
                type: "column",
                toolTipContent: "{y} metric tons",
                dataPoints: dataPoints
            }]
        });
        
        $.get("../data/tuna-production.csv", getDataPointsFromCSV);
        
        //CSV Format
        //Year,Volume
        function getDataPointsFromCSV(csv) {
            var csvLines = points = [];
            csvLines = csv.split(/[\r?\n|\r|\n]+/);
            for (var i = 0; i < csvLines.length; i++) {
                if (csvLines[i].length > 0) {
                    points = csvLines[i].split(",");
                    dataPoints.push({
                        label: points[0],
                        y: parseFloat(points[1])
                    });
                }
            }
            chart.render();
        }
    }
</script>

<?php include '../footer.php'; ?>